inherit "/std/room";

#include __PATH__(1)"defs.h"

int guckstu();


protected void create() {
  ::create();

  SetProp(P_INT_SHORT, "Eine schummrige Huette");
  SetProp(P_INT_LONG, BSLF(
    "Viel ist hier in der Huette immer noch nicht los. Aber Du siehst "
    "in der Wand einen Knopf und einen Spiegel."));

  SetProp(P_LIGHT, 1);
  SetProp(P_INDOORS, 1);
  SetProp(P_LIGHT_TYPE, LT_GLOWING);


  AddDetail("knopf", BSLF(
    "Es ist ein, aeh, Druckknopf."));
  AddDetail("spiegel", BSLF(
    "Du kannst hineinblicken."));


  /* Bitte nicht erschrecken, jetzt wirds eklig. Aber Du kannst fuer den
     Anfang ein wenig mit den Beispielen herumspielen, ich habe versucht,
     die haeufigsten Faelle, wie man Commands benutzt, abzudecken.
     Die Erklaerungen habe ich teilweise stark vereinfacht, damit es nicht
     zu kompliziert wird.
     Ausfuehrlich steht das alles in "man addcmd" und "man addcmd_bsp",
     aber diese Hilfeseiten sind sehr lang und vermutlich fuer den Anfang
     eher verwirrend. Ausserdem gibt es in /doc/beispiele etwas zu AddCmd. */


  // 1. Beispiel: Ein Kommando, das nur eine Meldung ausgibt.

  /* Diese erste Zeile nimmst Du am Besten erst einmal so als gegeben hin,
     in die sieben Abgruende von AddCmd() steigen wir spaeter noch herab. */
  AddCmd("drueck|druecke&knopf|druckknopf&\n\bimpossible", 0,
    /* Der dritte Parameter ist ein String, in dem alles weitere aneinander-
       gefuegt steht, getrennt durch "|" und "^".
       Zuerst steht die Nachfrage, falls statt "knopf" bzw. "druckknopf" ein
       falsches Wort eingegeben wurde oder es ganz fehlt: */
    "Was willst Du @verben?|"
    // Dann die Ausgabe an den Spieler:
    "Du drueckst den Knopf. Ein lautes Klingeln ertoent, das sofort "
    "verstummt, als Du den Knopf loslaesst.^"
    /* Dann die Ausgabe an alle anderen im Raum. Beachte, dass der gesamte
       String durch replace_personal() gejagt wird, die zugehoerige Manpage
       klaert Dich auf, welche Ausdruecke erkannt und ersetzt werden. */
    "@WER1 klingelt Sturm.^");


  // 2. Beispiel: Ein Kommando, wo etwas dynamisch passiert.

  /* Hier steht als zweiter Parameter eine Closure, die gerufen wird. Man
     kann da alles moegliche machen, der Rueckgabewert entscheidet, ob
     der Aufruf erfolgreich (!=0) war, oder ob sich das Kommando gar nicht
     angesprochen fuehlt und die Syntax an anderen Objekten im Raum
     getestet wird (==0). */
  AddCmd("blick|blicke&spiegel", #'guckstu,
    /* Hier auch wieder die Nachfrage, falls "spiegel" nicht oder falsch
       eingegeben wurde. Die restlichen Ausgaben muss guckstu() erledigen: */
    "Wo hinein moechtest Du blicken?");
}

/* Normalerweise sollte man seine Funktionen etwas sinnvoller benennen, aber
   naja, ist schon spaet ... */
int guckstu() {
  tell_object(TP, BSLF(
    "\nHILFE! Ein schreckliches Monster schaut Dich an:\n\n"+
    TP->long()));
  tell_room(TO, BSLF(
    TP->Name()+" schaut entsetzt in den Spiegel."),
    /* Die Meldung geht an alle ausser this_player(), also denjenigen, der
       den Funktionsaufruf von guckstu() ausgeloest hat: */
    ({TP}));
  return 1;
}

