inherit "/std/room";

#include __PATH__(1)"defs.h"

int cmd_knopf();

int schoki_da = 1; // 1 wenn Schoki vorhanden ist, 0 wenn nicht

protected void create() {
  ::create();

  SetProp(P_INT_SHORT, "Eine Huette mit verstecktem Gegenstand");
  SetProp(P_INT_LONG, BSLF(
    "Diese Huette sieht auf den ersten Blick recht leer aus."));

  SetProp(P_LIGHT, 1);
  SetProp(P_INDOORS, 1);
  SetProp(P_LIGHT_TYPE, LT_GLOWING);

  AddDetail("blick", BSLF(
    "Dein Blick faellt auf die kahle Wand, hier ist echt nichts los."));
  AddDetail("wand", BSLF(
    "An der Wand ist nichts zu finden, nur ein kleiner Knopf ist da "
    "angebracht."));
  AddDetail("knopf", BSLF(
    "Der Knopf ist so klein und niedlich, Du moechtest ihn doch bestimmt "
    "gern mal druecken, oder?"));

  AddCmd("drueck|druecke&knopf", #'cmd_knopf,
    "Wen oder was willst Du druecken?^");
}

void reset() {
  ::reset();
  if (!schoki_da) {
    // Einmal pro Reset gibts neue Schoki:
    tell_room(TO, BSLF(
      "Der Knopf an der Wand knirscht leise."));
    schoki_da = 1;
  }
}

int cmd_knopf() {
  if (!schoki_da) {
    // Diesen Reset wurde die Schoki schon abgeholt:
    tell_object(TP, BSLF(
      "Du drueckst den Knopf, aber nichts passiert. Gedulde Dich ein wenig "
      "und probiere es spaeter nochmal."));
    tell_room(TO, BSLF(
      TPNC+" macht sich an der Wand zu schaffen. Nichts passiert."), ({TP}));
    return 1;
  }

  /* Das Objekt wird geclont ... */
  object ob = clone_object(__PATH__(1)"obj/schoki");
  if (!objectp(ob)) {
    /* ... aber es gab dabei einen Fehler, das Objekt konnte nicht erzeugt
       werden: */
    tell_object(TP, BSLF(
      "Da ist wohl etwas schiefgegangen, Du hoerst von weiter oben nur "
      "ein resigniertes Jammern."));
    tell_room(TO, BSLF(
      TPNC+" macht sich an der Wand zu schaffen. Von oben hoerst Du "
      "Gejammer."), ({TP}));
  } else if (ob->move(TP, M_GET) == MOVE_OK) {
    /* Beim Bewegen eines Gegenstandes in den Spieler ist eine Pruefung auf
       den Erfolg des Aufrufes Pflicht. Fuer moegliche Gruende, dass move()
       fehlschlaegt, lies Dir bitte die Manpage zu move() durch.

       Das Objekt wurde erfolgreich erzeugt, und es wurde erfolgreich in den
       Spieler bewegt, der die Aktion ausgeloest hat: */
    tell_object(TP, BSLF(
      "Eine Klappe oeffnet sich an der Decke, und etwas faellt von oben "
      "herab. Geschickt faengst Du es auf."));
    tell_room(TO, BSLF(
      "Etwas faellt von oben herab und wird geschickt von "+TPN+
      " aufgefangen."), ({TP}));
    schoki_da = 0;
  } else {
    /* Das Objekt wurde erfolgreich erzeugt, aber es konnte nicht in den
       Spieler bewegt werden. Da das Objekt in diesem Fall sehr einfach
       gebaut ist und keine Sonderbehandlung dafuer beinhaltet, bewegt
       zu werden, ist der Spieler offensichtlich ueberladen. Wir muessen
       also in diesem Fall nicht pruefen, welchen Fehlerwert move()
       zurueckgeliefert hat. */
    tell_object(TP, BSLF(
      "Eine klappe oeffnet sich an der Decke, und etwas faellt von oben "
      "herab. Du bist aber schon zu vollgeladen, um es noch halten zu "
      "koennen. Es faellt zu Boden."));
    tell_room(TO, BSLF(
      "Etwas faellt von oben herab, aber "+TPN+" stellt sich zu dusslig "
      "an. Schnell, hebe es auf, bevor "+TP->QueryPronoun(WER)+" sich "
      "besinnt!"), ({TP}));
    schoki_da = 0;
    /* Beim Bewegen des Objektes in den Raum kann auch etwas schiefgehen,
       aber ueblicherweise passiert das nur in seltenen Ausnahmefaellen.
       Normalerweise prueft man den Rueckgabewert von move() beim Bewegen
       von Gegenstaenden oder Spielern in einen Raum nicht, denn wenn das
       nicht klappt, WILL man Debug-Output auf den entsprechenden Magier-
       Ebenen und im Fehlerteufel haben: */
    ob->move(TO, M_PUT);
  }
  return 1;
}

