inherit "/std/room";

#include __PATH__(1)"defs.h"
#include <questmaster.h>

int cmd_hebel();


protected void create() {
  ::create();

  SetProp(P_INT_SHORT, "Eine Huette mit Hebel");
  SetProp(P_INT_LONG, BSLF(
    "Diese Huette ist komplett leer. Na sowas. Nur an einer Stelle ragt ein "
    "Hebel aus der Wand. Ein kleines Schild haengt darunter."));

  SetProp(P_LIGHT, 1);
  SetProp(P_INDOORS, 1);
  SetProp(P_LIGHT_TYPE, LT_GLOWING);

  AddDetail("hebel", BSLF(
    "Da kannst Du dran ziehen."));
  AddDetail("schild", BSLF(
    "Das kannst Du lesen (wenn Du lesen kannst.)"));

  AddReadDetail("schild", BSLF(
    "\"Zum Loesen der Miniquest hier ziehen\".\n"
    "(Steht da. Was fuer eine Miniquest?)"));

  AddCmd("zieh|ziehe&hebel", #'cmd_hebel,
    "Wen oder was willst Du @verben?^");
}

int cmd_hebel() {
  /* Miniquest erfolgreich absolviert - bitte lies "man GiveMiniQuest".
     Wenn Du in Deinem Code pruefen willst, ob der Spieler die Miniquest
     bereits absolviert hat, lies bitte "man HasMiniQuest". */
  int err = QM->GiveMiniQuest(TP);

  /* Fuer die Infos, die der Questerzmagier zum Eintragen Deiner Miniquest
     braucht, lies bitte "man AddMiniQuest". Du kannst ihm normalerweise
     einfach eine Mail schreiben, die Eintraege fuer alle Argumente auf
     der Manpage enthaelt. */

  if (err == 1) {
    SetProp(P_NAME_ADJ, 0);
    SetProp(P_ARTICLE, 0);
    SetProp(P_NAME, "Ein Hebel");

    // Ausgaben auf der Abenteuer-Ebene:
    CHMASTER->join("Abenteuer", TO);
    CHMASTER->send("Abenteuer", TO,
      sprintf("Juchu! Ich werde doch so gern gezogen! Danke, %s!", TPN),
      MSG_SAY);
    CHMASTER->leave("Abenteuer", TO);
  } else {
    string msg;
    switch (err) {
      case -1:
        msg = "Du hattest die Miniquest bereits zuvor geloest.";
        break;
      case -2:
      case -4:
        /* Diese Meldung sollte hier nicht ueberraschen, denn dieses
           Beispiel ist hoffentlich nicht im Questmaster eingetragen: */
        msg = "Seltsam. Die Miniquest scheint nicht eingetragen zu sein.";
        break;
      case -5:
        msg = "Du bist mit einem Gastspieler eingeloggt. Gastspieler "+
              "bekommen keine Miniquests gutgeschrieben. Hat es trotzdem "+
              "Spass gemacht?";
        break;
      default:
        msg = "Irgendetwas ist schiefgegangen. Ein Magier waere vermutlich "+
              "sehr daran interessiert, was Du gemacht hast. Bitte sei so "+
              "nett und verstaendige einen. Danke!";
    }
    tell_object(TP, BSLF(msg));
  }
  return 1;
}

