inherit "/std/room";

#include __PATH__(1)"defs.h"

int cmd_obst();


protected void create() {
  ::create();

  SetProp(P_INT_SHORT, "Eine Huette mit Obst");
  SetProp(P_INT_LONG, BSLF(
    "Die Huette ist irgendwie beleuchtet, aber das ist es nicht, was "
    "Deine Aufmerksamkeit fesselt. Auf dem Tisch, der in der Mitte des "
    "Raumes steht, befindet sich eine Schale voller Obst. Das sieht "
    "wirklich appetitlich aus, Du moechtest es direkt essen."));

  SetProp(P_LIGHT, 1);
  SetProp(P_INDOORS, 1);
  SetProp(P_LIGHT_TYPE, LT_GLOWING);

  AddCmd("iss|ess|esse&obst", #'cmd_obst,
    "Wen oder was willst Du essen?^");
}


/*
  Sollverhalten der Tanke:
  Alle 40 min pro Spieler je 100+random(60) Food und Drink tanken, dabei
  Ticks von 12 LP/KP. Saettigung nur 5 Food.
*/

/*
  Anmerkung:
  Es ist guter Stil, in einem Kommentar vor dem Code der Tanke zu
  dokumentieren, welche Werte Du mit dem Erzmagier der Heilungsbalance
  ausgehandelt hast.

  Dies sind exakt die Werte, die die Tanke am Bergpfad oberhalb von
  Kobayashis Seilbahnstation verwendet. Sprich Deine Tanken auf jeden
  Fall mit dem Erzmagier, der fuer die Heilungsbalance zustaendig ist, ab.
  (Das ist momentan Humni, falls sich das aendert, weiss Dein Sponsor das
  aber.)

  Generell solltest Du fuer Heilungsangelegenheiten die Manpage wiz/heilung
  lesen.
*/
int cmd_obst() {
  /* 
     Allgemeiner Hinweis zum Arbeiten mit Timed Keys und Heilstellen:

     Als erstes solltest Du bitte die Manpages zu check_timed_key() und
     check_and_update_timed_key() nachlesen.
     Wir haben hier einen Sonderfall: Wir wollen nur Heilung alle 40
     Minuten erlauben, UND wir wollen nicht, dass der Spieler erst wieder
     40 Minuten warten muss, wenn er dieses Mal nichts essen kann, weil
     er gerade ueberfressen ist. Deshalb pruefen wir erst den Key, bevor
     wir "wie ueblich" mit check_and_timed_key() arbeiten.

     Wenn der Spieler auch die Wartezeit aufgebrummt bekommen soll, falls
     er gerade ueberfressen ist, dann sollte man so vorgehen wie in dem
     Beispiel der Manpage.
  */

  /*
     Da der Timed Key ueber das ganze Mud eindeutig sein muss, empfiehlt
     es sich, den eigenen Magiernamen darin zu verwenden. Gute Praxis ist
     es, wenn Du etwas wie "Magiername_Gebiet_Stelle" verwendest, dann
     kommst Du auch mit Deinen eigenen Timed Keys nicht durcheinander.
  */

  // Beim Ueberpruefen nicht Key setzen, TP koennte ja vollgefuttert sein:
  if (TP->check_timed_key("notstrom_tutorial2018_obst")==0) {
    if (TP->eat_food(5, 0,
        "'Esst Obst, und Ihr bleibt gesund', sagten sie. Jetzt hast Du "
        "schon so viel Obst gegessen, und Dir wird immer schlechter ...")) {
      // Returnwert wurde bereits oben geprueft:
      TP->check_and_update_timed_key(2400, "notstrom_tutorial2018_obst");
      /* Diese beiden Zeilen fuehren die eigentliche Heilung durch. Bitte
         auch hier die Manpages lesen: */
      TP->buffer_hp(100+random(60), 12);
      TP->buffer_sp(100+random(60), 12);

      tell_object(TP, BSLF(
        "Du verzehrst etwas Obst aus der Schale und fuehlst Dich gleich "
        "besser."));
      tell_room(TO, BSLF(
        TPN+" etwas mampft Obst aus der Schale."),
        ({TP}));
    }
  } else {
    tell_object(TP, BSLF(
      "Du hast Dich hier erst kuerzlich bedient und kannst gerade kein "
      "Obst sehen. Vielleicht ein andermal ..."));
  }
  return 1;
}

