inherit "/std/room";

#include __PATH__(1)"defs.h"


protected void create() {
  ::create();

  SetProp(P_INT_SHORT, "Eine schummrige Huette");
  SetProp(P_INT_LONG, BSLF(
    "Du kannst hier im Raum Krempel hinlegen, der wird bei Raumreset in die "
    "Kiste verschoben. Das kannst Du mit\n"
    "  xcall $h->reset()\n"
    "auch provozieren."));

  SetProp(P_LIGHT, 1);
  SetProp(P_INDOORS, 1);
  SetProp(P_LIGHT_TYPE, LT_GLOWING);

  AddItem(__PATH__(1)"obj/kiste", REFRESH_REMOVE);
}

void reset() {
  ::reset();

  object kiste = present_clone(__PATH__(1)"obj/kiste");
  // Sollte nicht passieren, da in :reset() bereits AddItem() gerufen wurde:
  if (!objectp(kiste)) return;

  /* Doku zu filter() bitte in "man filter" nachlesen. Wir benutzen hier eine
     Inline-Closure, so etwas sollte ja aus den bisherigen Beispielen wohl-
     bekannt sein: */
  object *zeugs = filter(all_inventory(), function int(object o) {
    return (!living(o)); });
  if (pointerp(zeugs) && sizeof(zeugs)) {
    tell_room(TO, BSLF(
      "Der Raum gurgelt, die Kiste ruelpst."));
    /*
      Wie in "man call_other" erlaeutert, muss man nicht durch ein Objekt-
      Array durchiterieren, wenn man eine Member-Function fuer jedes einzelne
      Objekt aufrufen moechte, sondern kann die folgende Syntax verwenden:
     */
    zeugs->move(kiste, M_PUT);
  } else {
    tell_room(TO, BSLF(
      "Die Kiste geht diesmal leer aus."));
  }
}
