inherit "/std/room";

#include __PATH__(1)"defs.h"

private void greeting();
private string* greeted = ({});


protected void create() {
  ::create();

  SetProp(P_INT_SHORT, "Eine schummrige Huette");
  SetProp(P_INT_LONG, BSLF(
    "In diesem Raum hier ist nichts los. Du kannst also eigentlich einfach "
    "weitergehen."));

  SetProp(P_LIGHT, 1);
  SetProp(P_INDOORS, 1);
  SetProp(P_LIGHT_TYPE, LT_GLOWING);
}

void reset() {
  ::reset();
  /* Bei Raumreset "vergessen" wir, wer alles schon die verzoegerte Meldung
     bekommen hat, damit man die auch mehrmals erhalten kann, ohne dass man
     jedesmal von ihr bespammt wird. */
  greeted = ({});
}

public varargs void init(object origin) {
  ::init();

  if (TP &&
      interactive(TP) &&
      member(greeted, getuuid(TP)) == -1 &&
      find_call_out(#'greeting) == -1)
    call_out(#'greeting, 3);
}

private void greeting() {
  /* Wir pruefen hier, ob der Spieler, der den Callout ausgeloest hat,
     ueberhaupt noch anwesend ist. Wenn der Spieler gestorben ist, ausgeloggt
     hat oder den Raum verlassen hat, machen wir gar nichts. */
  if (ENV(TP) == TO)
    greeted += ({getuuid(TP)});
    tell_object(TP, BSPS(
      "Tatsaechlich. In diesem Raum hier ist ueberhaupt nichts los."));
}
