inherit "/std/room";

#include __PATH__(1)"defs.h"

private void delayed();


protected void create() {
  ::create();

  SetProp(P_INT_SHORT, "Eine schummrige Huette");
  SetProp(P_INT_LONG, BSLF(
    "Noch ein leerer Raum. Moment - nicht ganz, da ist ein haesslicher Fleck "
    "auf dem Boden."));

  SetProp(P_LIGHT, 1);
  SetProp(P_INDOORS, 1);
  SetProp(P_LIGHT_TYPE, LT_GLOWING);

  AddDetail("fleck", function string() {
    /* Ueblicherweise sollte man sicherstellen, dass keine Schwemme an
       call_outs auftreten kann, denn dadurch kann man das Mud relativ leicht
       in die Knie zwingen. Gerade wenn die Callouts wie hier direkt von den
       Spielern gestarten werden koennen, ist das wichtig. Wir checken also,
       bevor wir einen neuen Callout starten, ob bereits ein Callout auf
       dieselbe Function laeuft: */
    if (find_call_out(#'delayed) == -1)
      call_out(#'delayed, 3);
    else
      return BSLF("Nicht so schnell hintereinander! Willst Du das Mud mit "
        "Callouts fluten?");

    return BSLF("Ja, dieser Fleck ist wirklich haesslich.");
  });
}

private void delayed() {
  /* Wir pruefen hier, ob der Spieler, der den Callout ausgeloest hat,
     ueberhaupt noch anwesend ist. Wenn der Spieler gestorben ist, ausgeloggt
     hat oder den Raum verlassen hat, machen wir gar nichts. */
  if (ENV(TP) == TO)
    tell_object(TP, BSPS(
      "WER IST HIER HAESSLICH?!",
      "Eine Stimme droehnt: "));
}
