inherit "/std/npc";

#include <new_skills.h>
#include __PATH__(1)"defs.h"


private int ausholen;

protected void create() {
  if (!clonep()) {
    set_next_reset(-1);
    return;
  }
  ::create();

  create_default_npc(20, 600);

  SetProp(P_SHORT, "Ein angriffslustiger Zwerg");
  SetProp(P_LONG, BSLF(
    "Diesmal hat Kawumm eine spezielle Axt, und er greift ab und zu staerker "
    "an."));
  SetProp(P_NAME, "Kawumm");
  SetProp(P_ARTICLE, 0);
  SetProp(P_GENDER, MALE);

  AddId(({"zwerg", "kawumm"}));
  SetProp(P_ALIGN, 100);
  SetProp(P_RACE, "Zwerg");
  SetProp(P_SIZE, 102);

  SetProp(P_MURDER_MSG,
    "He! Ich gehoere doch zu Notstroms Magiertutorial, %s.");
  /* Wir setzen hier auch mal eine Kill-Message, dieser Zwerg koennte ja
     sogar mal wen erwischen: */
  SetProp(P_KILL_MSG,
    "Kommt davon, wenn man sich an einem Magiertutorial vergreift, %s!");
  SetProp(P_DIE_MSG, " kippt um wie eine leere Bierflasche.\n");

  AddItem(__PATH__(1)"obj/axt2", REFRESH_NONE|CLONE_WIELD);
}

/* Ab und zu (20% Chance) startet Kawumm eine starke Attacke, die braucht
   dann aber ein paar Runden: */
void Attack(object enemy) {
  if (ausholen) {
    if (ausholen == 1) {
      mixed waffe = QueryProp(P_WEAPON);
      string* damtype = ({DT_BLUDGEON});
      if (waffe) damtype = waffe->QueryProp(P_DAM_TYPE);

      tell_room(ENV(), BSLF(
        "Kawumm semmelt so richtig feste zu."));
      enemy->Defend(300, damtype, 0, TO);
    }
    --ausholen;
    return;
  }

  if (!random(5)) {
    ausholen = 3;
    tell_room(ENV(), BSLF(
      "Kawumm holt mal so richtig weit aus, um dann um so fester "
      "zuzuschlagen."));
    return;
  }
  ::Attack(enemy);
}
