inherit "/std/npc";

#include <new_skills.h>
#include __PATH__(1)"defs.h"


protected void create() {
  if (!clonep()) {
    set_next_reset(-1);
    return;
  }
  ::create();

  create_default_npc(20, 600);

  SetProp(P_SHORT, "Ein spiegelblanker Zwerg");
  SetProp(P_LONG, BSLF(
    "Dieser Zwerg ist (oha!) FRISCHGEWASCHEN!!\n"
    "Er ist so spiegelblank, dass Du Dir tatsaechlich vorstellen kannst, "
    "dass er nicht nur Licht, sondern noch viel mehr reflektiert."));
  SetProp(P_NAME, "Kawumm");
  SetProp(P_ARTICLE, 0);
  SetProp(P_GENDER, MALE);

  AddId(({"zwerg", "kawumm"}));
  SetProp(P_ALIGN, 100);
  SetProp(P_RACE, "Zwerg");
  SetProp(P_SIZE, 102);

  SetProp(P_MURDER_MSG,
    "He! Ich gehoere doch zu Notstroms Magiertutorial, %s.");
  /* Wir setzen hier auch mal eine Kill-Message, dieser Zwerg koennte ja
     sogar mal wen erwischen: */
  SetProp(P_KILL_MSG,
    "Kommt davon, wenn man sich an einem Magiertutorial vergreift, %s!");
  SetProp(P_DIE_MSG, " kippt um wie eine leere Bierflasche.\n");
}

/* Defend() wird aufgerufen, wenn dieses Objekt etwas auf die Omme bekommt -
   oder bekommen soll. Resistenzen erledigt man am besten ueber die Prop aus
   dem vorangegangenen Beispiel, aber manchmal moechte man ja etwas machen,
   was ein wenig lustiger ist. */
public int Defend(int dam, string|string* dam_type, int|mapping spell,
                        object enemy) {
  // Physische Attacken werden unveraendert behandelt:
  if (!spell || (mappingp(spell) && spell[SP_PHYSICAL_ATTACK]))
    return ::Defend(dam, dam_type, spell, enemy);

  tell_object(enemy, BSLF(
    "Kawumm ist so glaenzend blankpoliert, dass er Deinen Angriff glatt "
    "reflektiert."));
  tell_room(ENV(enemy), BSLF(
    "Kawumm ist so glaenzend blankpoliert, dass er den Angriff von "+
    enemy->name()+"glatt reflektiert."),
    ({enemy}));

  m_add(spell, SP_RECURSIVE, 1);
  enemy->Defend(dam, dam_type, spell, enemy);
  /* Wir geben hier 0 zurueck, sind also vollstaendig immun gegen
     Spells ohne physische Schadenskomponente. Man koennte auch einen
     kleinen Teil des Schadens durchkommen lassen, aber dann haette
     der Zwerg einen anderen Namen: */
  return 0;
}
