/*
  Eine Moeglichkeit, eine Waffe nur fuer einen NPC zur Verfuegung zu
  stellen ist ein wenig frustrierend fuer Spieler. Man sollte Beispiele
  wie dieses nicht ungeprueft uebernehmen. Waffen, die kein Spieler zuecken
  kann, stossen meist nicht auf sehr hohen Enthusiasmus beim Spieler, die
  betreffende Gegend mehrmals zu aufzusuchen.
*/
inherit "/std/weapon";

#include <new_skills.h>
#include __PATH__(1)"defs.h"


protected void create() {
  if (!clonep()) {
    set_next_reset(-1);
    return;
  }
  ::create();

  SetProp(P_SHORT, "Eine besondere Axt");
  SetProp(P_LONG, BSLF(
    "Dies ist die Axt von Kawumm, dem Zwerg. Niemand kann so damit zuhauen "
    "wie er."));

  SetProp(P_NAME, "Axt");
  SetProp(P_GENDER, FEMALE);
  AddId(({"axt"}));

  SetProp(P_WC, 180);
  SetProp(P_WEAPON_TYPE, WT_AXE);
  SetProp(P_DAM_TYPE, DT_SLASH);
  SetProp(P_NR_HANDS, 1);

  /* "Restriktionen" bezieht sich hier konkret auf das Zuecken der Waffe.
     In diesem Beispiel wird das anhand der Function wield_check()
     ueberprueft, die sich in DIESEM Objekt befinden muss: */
  SetProp(P_RESTRICTIONS, ([SR_FUN: "wield_check"]));

  SetProp(P_VALUE, 200);
  SetProp(P_WEIGHT, 3250);
  SetProp(P_SIZE, 90);

  SetProp(P_MATERIAL, ([MAT_STEEL:100]));
}

public string wield_check() {
  /* Wir pruefen direkt, ob derjenige, der die Axt im Inventory hat, der
     legale Besitzer ist. Diese Axt funktioniert also z.B. nicht mehr,
     wenn man einen anderen NPC damit ausruesten moechte. */
  if (load_name(ENV()) != __PATH__(1)"npc/zwerg4")
    return BSLF(
      "Dies ist Kawumms persoenliche Axt. Sie ist so dermassen unhandlich, "
      "dass Du sie nicht zuecken kannst.");
  return 0;
}
