#pragma strict_types, save_types, pedantic, range_check
#pragma no_clone

#include <thing/language.h>
#include <living/comm.h>

// Per Default nur an alle Items im Inventar weiterleiten.
public varargs void ReceiveMsg(string msg, int msg_type, string msg_action,
                              string msg_prefix, object origin)
{
  all_inventory()->ReceiveMsg(msg, msg_type, msg_action,
                              msg_prefix, origin || previous_object());
}

// Wrapper fuer ReceiveMsg()

public void ReceiveMultiSense(struct wave_s *msgs, string action=0,
    int commontypes=0)
{
  all_inventory()->ReceiveMultisense(msgs, action, commontypes);
}

public void ReceiveSay(string msg,
    string prefix = ({string})previous_object().Name(WER, 1) + " sagt: ",
    struct wave_s *alt =
        ({(<wave_s>
            msg: "@WER1 bewegt die Lippen, Du hoerst jedoch nichts.",
            type: MT_LOOK)})
    )
{
  // Nachricht in struct konvertieren, ans Anfang vom Array stellen
  alt = ({(<wave_s> msg: msg, prefix: prefix, type: MT_LISTEN)}) + alt;
  // Rest macht ReceiveMultiSense()
  ReceiveMultiSense(alt, MA_SAY, MSG_BS_LEAVE_LFS);
}

