/* a finger
 * Original (c) 14.03.1993 by Taube @Nightfall
 * Umsetzung fuer Morgengrauen 09.08.1993 by Loco

   Verwendung ausserhalb von Morgengrauen ist gestattet unter folgenden
   Bedingungen:
   - Benutzung erfolgt auf eigene Gefahr. Jegliche Verantwortung wird
     abgelehnt.
   - Auch in veraenderten oder abgeleiteten Objekten muss ein Hinweis auf
     die Herkunft erhalten bleiben.
   Ein Update-Service besteht nicht.

 * 29.Okt 1993 Seherversion.
 * spaeter auch fuer externen Aufruf verwendbar gemacht
 * 13.Okt .plan und .project koennen auch in ~loco/plans sein.
 * 15.Jan 1994 angepasst an neues Speicherformat
 * 02-05.Dez94 -n, -p
 *
 * Gelegentlich minor changes, zuletzt 04.Okt.95
 *
 * 2025-06-28  rumata
 *   Daten einzeln per QueryProp auslesen (da QueryProperties im
 *   playerobjekt nicht mehr geboten).
 */

#pragma strong_types,save_types
#pragma no_clone, no_shadow

#include <config.h>
#include <properties.h>
#include <wizlevels.h>
#include <new_skills.h>
#include <userinfo.h>
#include <config.h>

#define HBINT    2   /* interval between two heart_beats in seconds */
#define MINIDLE 60   /* minimum idle time in seconds to be stated idle */
#define TBANISH_EXTRACT 71..  /* Der benoetigte Teil des TBanish-strings */

#define TP this_player()
#define wiz (local && IS_LEARNER(TP))
#define seer (local && IS_SEER(TP))
#define IN ((pdata->QueryProp(P_GENDER)==2)?"in":"")


#define FLAG_NOPLAN 1
#define FLAG_LONG 2
#define FLAG_SPONSOR 4
#define FLAG_VIS_LOGOUT 8
#define FLAG_AVATAR 16


mapping properties;
int age,invis,hc_play;
int filetime;
mapping relatives;


void create()
{
  seteuid(getuid());
  filetime=0;
}

mixed QueryProp( mixed key ) {
	return properties[key];
}

mixed Query( mixed key ) {
	return properties[key];
}

string timediff(int time)
{
  string ret;

  ret="";
  if ( time >= 86400*365 ) {
    ret+=time/(86400*365)+"a ";
    time%=(86400*365);
  }
  if(time>=86400) {
    ret+=time/86400+"d ";
    time%=86400;
  }
  if(time<36000) ret+="0";
  ret+=time/3600+":";
  time%=3600;
  if(time<600) ret+="0";
  ret+=time/60+":";
  time%=60;
  if(time<10) ret+="0";
  ret+=time+"";
  return ret;
}

string sponsoring(string name)
{
  string *s,s2,s3,s4;
  // Daten einlesen, wenn die daten aelter als 1 Tag sind oder sich
  // /data/etc/SPONSOR geaendert hat.
  if ((time() > filetime+86400) ||
      filetime!=file_time("/data/etc/SPONSOR")) 
  {
      relatives=m_allocate(0,2);
      filetime=file_time("/data/etc/SPONSOR");
      s=explode(read_file("/data/etc/SPONSOR"),"\n");
      foreach(string str: s) { 
	  sscanf(str,"%s: %s macht %s zum Learner.",s2,s3,s4);
	  if (IS_LEARNER(lower_case(s3)) && IS_LEARNER(lower_case(s4)))
          {
             relatives[lower_case(s4),0]=s3;
             s3=lower_case(s3);
             s4+=" ("+query_wiz_level(lower_case(s4))+")";
             if (!relatives[s3,1]) relatives[s3,1]=({s4});
             else relatives[s3,1]+=({s4});
          }
      }  
  }
  s2="";
  if (relatives[name,0])
    s2+="Vorfahre:     "+relatives[name,0]+"\n";
  if (relatives[name,1])
    s2+="Nachfahre(n): "+break_string(implode(relatives[name,1],", "),78,14)[14..];
  return s2;
}

varargs string finger_single(string str,int local)
{
  string ip,text,ipnum,filename,away,presay;
  int wizlevel,idle,flags,last;
  mixed h,data,tmp;
  object player,ob;
  object pdata;

  /*DEBUG###  tell_object((find_player("loco")||this_object()),"Finger request: '"+str+"'("+local+")\n");/**/
  str=lower_case(str);
  text="";
  away="";
  hc_play=0;
  
  h=explode(str," ");
  if (sizeof(h)==1) h=explode(str,"+");
  if (member(h,"-n")>=0) flags=FLAG_NOPLAN;
  if (member(h,"-p")>=0) flags=0;
  if (member(h,"-l")>=0) flags|=FLAG_LONG;
  if (member(h,"-s")>=0) flags|=FLAG_SPONSOR;
  if (member(h,"-v")>=0) flags|=FLAG_VIS_LOGOUT;
  if (member(h,"-a")>=0) flags|=FLAG_AVATAR;

  h=(h-({"-n","-p","-l","-s", "-v","-a"}));
  if (!sizeof(h)) {
    text="Du solltest schon sagen, wer Dich interessiert!\n";
    if (local) return write(text),0;
    else return text;
  }
  str=h[0];
  if (!sizeof(str) || str[0]<'a' || str[0]>'z') {
    text="Also, so ("+str+") heisst bestimmt kein Spieler hier!\n";
    if (local) return write(text),0;
    else return text;
  }

  /* does this player exist? */
  str=old_explode(str,".")[0];
  player=find_player(str)||find_netdead(str);

  if( (!master()->find_userinfo(str) && !player) )
  {
    text="Hmm... diesen Namen gibt es im "MUDNAME" nicht.\n";
    if (tmp="/secure/master"->QueryBanished(str)){
      text="Hoppla - dieser Name ist reserviert oder gesperrt (\"gebanisht\")!\n";
      if ( tmp != "Dieser Name ist gesperrt." )
          text += "Grund fuer die Sperrung: " + tmp +
              (member( ({'!','?','.'}), tmp[<1] ) != -1 ? "" : ".") + "\n";
    }
    if (local) return write(text),0;
    else return text;
  }

  if (player) {
    hc_play=player->query_hc_play();
    pdata = player;
  }
  else {
    restore_object(SAVEPATH+str[0..0]+"/"+str);
    if (!properties) {
      text+="Mist!!! Das Einlesen der Daten klappt nicht wie es soll :-(\n";
      if (!local)
        return text;
      write(text);
      return "";
    }
    pdata = this_object();
  }
  tmp = pdata->QueryProp(P_PRESAY);
  presay = (stringp(tmp) && sizeof(tmp)>1) ? tmp[0..<2] : 0;

  if ( player && interactive(player) )
      ipnum = query_ip_number(player);
  else
      ipnum = pdata->QueryProp(P_CALLED_FROM_IP);
  // frueher stand in P_CALLED_FROM_IP evtl. auch der Name direkt drin
  // anstelle der numerischen IP
  ip=query_ip_name(ipnum)||pdata->QueryProp(P_CALLED_FROM_IP);
  if(player) {
      if (!interactive(player) || (idle=query_idle(player))<MINIDLE)
          idle=0;
      if (!(invis=age=player->QueryProp(P_INVIS)))
          age=player->QueryProp(P_AGE);
  } else {
    if (pdata->QueryProp(P_INVIS)) age=pdata->QueryProp(P_INVIS);
    idle=pdata->QueryProp(P_LAST_LOGOUT);
  }

   wizlevel=query_wiz_level(str);
   if ( (tmp = file_time(SAVEPATH+str[0..0]+"/"+str+".o")) <= 0 )
       // Hack, um bei ganz "frischen" Spielern (noch kein Savefile vorhanden)
       // die Ausgabe von 1.1.1970 zu verhindern
       tmp = time();
   last=pdata->QueryProp(P_LAST_LOGOUT);
   if ( last <= 0 || (!(flags&FLAG_VIS_LOGOUT) && wiz && wizlevel > 10
                  && pdata->QueryProp(P_INVIS) && tmp - last > 300) )
       last = tmp;
  /* output routine for all */
  if(player) {
    h=player->QueryProp(P_RACE);
    if(interactive(player) && (wiz || !invis)) {
      text+=capitalize(str)+" ist anwesend,\n"+
        "und zwar von: "+
          (wiz ? (ip+(ipnum?" ("+ipnum+")":"")):"")+
          (stringp(pdata->QueryProp(P_LOCATION)) ? (wiz ? "\n              [" : "")
           +capitalize(pdata->QueryProp(P_LOCATION))+
           ((pdata->QueryProp(P_LOCATION) != country(ip, ipnum))
            ? " (ueber "+country(ip, ipnum)+")" : "" )
           : (wiz?" [":"")+country(ip, ipnum))+(wiz ? "]":"")+".\n";
      if(idle)
        text+="Passiv seit: "+timediff(idle)+"\n";
     if (local)
      text+="Eingeloggt seit: "+dtime(pdata->QueryProp(P_LAST_LOGIN))+"\n";
     if (pdata->QueryProp(P_AWAY))
       away="z.Z. abwesend, Grund  : "+pdata->QueryProp(P_AWAY)+"\n";
    } else
      text+=capitalize(str)+" ist nicht anwesend.\nZuletzt eingeloggt von: "+
        (wiz ? (ip+(ipnum&&ipnum!=ip?" ("+ipnum+")":"")):"")+
        (stringp(pdata->QueryProp(P_LOCATION)) ?
         (wiz ? "\n                        [": "")
         +capitalize(pdata->QueryProp(P_LOCATION))+" (ueber "+country(ip, ipnum)+")":
         (wiz?" [":"")+country(ip, ipnum))+(wiz ? "]":"")+".\n"+
        "Zuletzt ausgeloggt: "+dtime(last)+" ("+timediff(time()-last)+").\n";
  }
  else {
    text+=capitalize(str)+" ist nicht anwesend.\nZuletzt eingeloggt von: "+
        (wiz ? (ip+(ipnum&&ipnum!=ip?" ("+ipnum+")":"")):"")+
        (stringp(pdata->QueryProp(P_LOCATION)) ?
         (wiz ? "\n                        [": "")
         +capitalize(pdata->QueryProp(P_LOCATION))+" (ueber "+country(ip, ipnum)+")":
         (wiz?" [":"")+country(ip, ipnum))+(wiz ? "]":"")+".\n"+
        "Zuletzt ausgeloggt: "+dtime(last)+" ("+timediff(time()-last)+").\n";
  }
  text+="Voller Name: "+(((h=presay) && h!="") ? h+" " : "")+
    capitalize((h=pdata->QueryProp(P_NAME)) ? h : str)+" "+
     ((h=pdata->QueryProp(P_TITLE)) ? h :
    ((mappingp(h=pdata->Query("guild_title")) && (h=(h[pdata->Query(P_GUILD)?pdata->QueryProp(P_GUILD):"abenteurer"])) ) ? h : "") )
       +"\n";

  if (pdata->QueryProp(P_GHOST)) text+="Hoppla, ein Geist!\n";
  if ((flags&FLAG_LONG)&&pdata->QueryProp(P_LONG))
    text+="Beschreibung: \n"+break_string(pdata->QueryProp(P_LONG),78,2);

  if(wiz ||
     (pdata->QueryProp(P_SHOWEMAIL)=="alle") ||
     ( (pdata->QueryProp(P_SHOWEMAIL)=="freunde") &&
       objectp(player) &&
       this_player() &&
       (ob=present("\n\bfband",player)) &&
       pointerp(tmp=ob->QueryProp(P_AUTOLOADOBJ)) &&
       pointerp(tmp=tmp[1]) &&
       (member(tmp,getuid(this_player()))!=-1))) tmp = 1;
  else tmp=0;
  string shell=pdata->QueryProp(P_RACE);
  if (!stringp(shell))
  {
    shell = master()->query_userlist(str, USER_OBJECT);
    shell = capitalize(explode(shell, "/")[3]);
    shell =(["Human":"Mensch","Dwarf":"Zwerg","Darkelf":"Dunkelelf",
             "Orc":"Ork"])[shell] || shell;
  }

  if (!stringp(shell)) shell="<keine>";
  int creation = master()->query_userlist(str, USER_CREATION_DATE);
  text+="Rasse: "+shell+",  Gilde: "+
                     ((h=pdata->QueryProp(P_VISIBLE_GUILD))?capitalize(h):((h=pdata->Query(P_GUILD))?capitalize(h):"Abenteurer"))+
                     ((h=pdata->QueryProp(P_VISIBLE_SUBGUILD_TITLE))?" ("+capitalize(h)+")":((h=pdata->QueryProp(P_SUBGUILD_TITLE))?" ("+capitalize(h)+")":""))+
                     ",  Geschlecht: "+({"neutral ?!","maennlich","weiblich","<verdammt seltsam>"})[pdata->QueryProp(P_GENDER)]+"\n"+
                      (seer ? "Alter: "+timediff(age*HBINT)+",   " : "")+
                      (wizlevel>=10?"Magierlevel: "+wizlevel+
          (wizlevel>=GOD_LVL?" (Mudgott)":str=="boing"?" (Mudgott a.D.)":str=="muadib"?" (Apostolischer Visitator)":wizlevel>=ARCH_LVL?" (Erzmagier)":IS_DEPUTY(str)?" (Hilfssheriff)":wizlevel>=ELDER_LVL?" (Weiser)":wizlevel>=LORD_LVL?" (Regionsmagier)":wizlevel>=SPECIAL_LVL?" (Hilfsmagier)":wizlevel>=DOMAINMEMBER_LVL?" (Regionsmitarbeiter)":wizlevel>WIZARD_LVL?" (Vollmagier)":" (Lehrling)"):
                       ("Spielerlevel: "+pdata->QueryProp(P_LEVEL)+( wizlevel ? " (Seher"+IN+")" : "" )+
                        (((h=pdata->Query(P_GUILD_LEVEL)) && h=h[pdata->Query(P_GUILD)]) ?
                         (",   Gildenlevel: "+h) : "" )
                        )) + ((sprintf("\nDatum des ersten Login: %s",
                                 (creation > 0) ? dtime(creation) : "vor dem 10. Nov 1995")))+
                         (tmp ? ("\nE-Mail-Adresse: "+((h=pdata->QueryProp(P_MAILADDR)) ? h : "keine")+"\n") : "\n");

  if (pdata->QueryProp(P_HOMEPAGE))
    text+="Homepage: "+pdata->QueryProp(P_HOMEPAGE)+"\n";

  if (stringp(data=pdata->QueryProp(P_MESSENGER))) {
    text+=sprintf("Messenger: %s", data);
    if (intp(data=pdata->QueryProp(P_ICQ))) {
      if (data<0 && IS_WIZARD(this_player())) data*=-1;
      if (data>0) text += sprintf(", ICQ: %d", data);
    }
    text+="\n";
  } else 
    if (intp(data=pdata->QueryProp(P_ICQ))) {
      if (data<0 && IS_WIZARD(this_player()))
        data*=-1;
      if (data>0)
        text+=sprintf("ICQ: %d\n",data);
    }

  if (pdata->QueryProp(P_MARRIED))
    text+="Verheiratet mit: "+capitalize(pdata->QueryProp(P_MARRIED))+"\n";

  if ( pointerp(pdata->QueryProp(P_SIBLINGS)) )
      text += ({ "Es", "Er", "Sie" })[pdata->QueryProp(P_GENDER)] + " ist Bluts" +
          ({ "verwandt mit ", "bruder von ", "schwester von " })
          [pdata->QueryProp(P_GENDER)] +
          CountUp(pdata->QueryProp(P_SIBLINGS)) + ".\n";

  text+=away;

  if(MASTER->check_late_player(str))
  {
    text+=capitalize(str)+" hat uns leider fuer immer verlassen.\n";
  }
  else
  {
    if (h=MASTER->QueryTBanished(str))
      text+=capitalize(str)+" will fruehestens "+h[TBANISH_EXTRACT];
  }
  
  if (h=pdata->QueryProp(P_TESTPLAYER))
  {
    text+=capitalize(str)+" ist Testspieler"+IN;
    if (stringp(h)) text+=" ("+h+")";
    text+=".\n";
  }
  if ( h=pdata->QueryProp(P_SECOND))
  {
    if (IS_WIZARD(this_player())) {
       text+=capitalize(str)+" ist";
       switch(pdata->QueryProp(P_SECOND_MARK)) {
         case -1: text+=" unsichtbar markierte"
                       +(pdata->QueryProp(P_GENDER)!=FEMALE ? "r": "");
                  break;
         case  0: text+=" nicht namentlich markierte"
                       +(pdata->QueryProp(P_GENDER)!=FEMALE ? "r": "");
                  break;
         default:
       }
       text+=" Zweitspieler"+IN;
       if (stringp(h))
         text+=" ("+capitalize(h)+")";
       text+=".\n";
    }
    else if (pdata->QueryProp(P_SECOND_MARK)>0)
    {
      text+=capitalize(str)+" ist Zweitspieler"+IN;
      if (stringp(h))
        text+=" ("+capitalize(h)+")";
      text+=".\n";
    }
    else if (pdata->QueryProp(P_SECOND_MARK)>-1)
      text+=capitalize(str)+" ist Zweitspieler"+IN+".\n";
  }

  if (pdata->QueryProp(P_DEADS))
  {
    text+="Bisher bereits "+pdata->QueryProp(P_DEADS)+" mal gestorben\n";
    // Bezieht sich nur auf den Zeitraum ab dem 30.11.'94
  }
  if(hc_play==1)
  {
    text+=capitalize(str)+" ist sehr mutig.\n";
  }
  if(hc_play>1)
  {
    text+=capitalize(str)+" ist am "+dtime(hc_play)+" in das Nirvana eingegangen.\n";
  }
  
  data=master()->query_userlist(str, USER_DOMAIN);
  if (sizeof(data)) {
    text+="Regionsmagier"+IN+" von     : "
          +implode(map(data,#'capitalize),", ")+".\n";
  }

  data="/secure/master"->get_domain_homes(str);
  data=filter(data-({"erzmagier"}),#'stringp);
  if ((wizlevel>=DOMAINMEMBER_LVL) && (sizeof(data)))
    text+="Regionsmitarbeiter"+IN+" von: "
          +implode(map(data,#'capitalize),", ")+".\n";

    data=master()->query_userlist(str, USER_GUILD);
    if (sizeof(data))
      text += "Gildenmagier"+IN+" von      : "
              +implode(map(data, #'capitalize), ", ")+".\n";

  // ggf. Avatar-URI mit ausgeben.
  if (flags & FLAG_AVATAR
      && stringp(pdata->QueryProp(P_AVATAR_URI)))
    text += "Avatar-URI: " + pdata->QueryProp(P_AVATAR_URI) + "\n";

  if (flags & FLAG_SPONSOR)
    text+=sponsoring(str);

  filename="/players/"+str+"/.project";
  if(file_size(filename)>=0)
    text+="Projekt: "+explode(read_file(filename), "\n")[0]+"\n";
  else {
    filename="/p/service/loco/plans/"+str+".project";
    if(file_size(filename)>=0)
      text+="Projekt: "+explode(read_file(filename), "\n")[0]+"\n";
  }
  if (seer && !(flags&FLAG_NOPLAN)) {
    filename="/players/"+str+"/.plan";
    if(file_size(filename)>=0)
      text+="Plan:\n"+read_file(filename);
    else {
      filename="/p/service/loco/plans/"+str+".plan";
      if(file_size(filename)>=0)
        text+="Plan:\n"+read_file(filename);
//      else
//      text+="Keine .plan-Datei.\n";
    }
  }
  properties=0;
  text=break_string(text,78,0,BS_LEAVE_MY_LFS);
  if (!local)
    return text;
  this_player()->More(text);
  pdata=0;
  return "";
}

string Finger(string str)
{
  if(!str || str=="") { notify_fail("Wen denn?\n"); return 0; }
  else
    return finger_single(str,1);
}
