// MorgenGrauen MUDlib
//
// thing/properties.h -- contains property definitions and prototypes
//
// $Id: properties.h,v 3.5 2003/08/07 15:09:33 Rikus Exp $

#ifndef __THING_PROPERTIES_H__
#define __THING_PROPERTIES_H__

// Type Flags indexing <prop> and they are used as well for Set() calls
#define F_VALUE         0
#define F_MODE          1
#define F_SET_METHOD    2
#define F_QUERY_METHOD  3
#define F_PROP_ENTRIES  4 // how many entries in <prop> mapping?

// The following are used as type flags for Set(), but they do not index
// <prop>, therfore they have a negative sign.
//
// F_SET_MAPPER sets F_SET_METHOD, but additionally sets the mode SETMAPPED
// automatically
#define F_SET_MAPPER    -F_SET_METHOD
// Flags for Set() to modify/manipulate F_MODE of a property in bit-wise
// manner (but are themselves not bitwise of course!).
#define F_MODE_AS       -400
#define F_MODE_AD       -500

// and from here the mode flags for Properties
#define SAVE            64
#define PROTECTED       128  // only this_object() can change the values
#define SECURED         256  // like PROTECTED, but never resetable
#define NOSETMETHOD     512  // Keine Set-Methode => Nicht mofifizierbar
#define SETMAPPED       0x4000 // Setmethod only maps, not sets
// Problem with the following: shadows, default methods etc. may change the
// result at runtime and they do not save that much time (or even at all?)
// because of the apply cache of the driver. Not used since 1995. But
// be careful about re-using the values because of ancient (!) savefiles
#define SETMNOTFOUND	1024 // Keine Set-Methode gefunden. Not used.
#define QUERYMNOTFOUND	2048 // Keine Query-Methode gefunden. Not used.
#define QUERYCACHED	4096 // Not used anymore
#define SETCACHED	8192 // Not used anymore

#endif // __THING_PROPERTIES_H__

#ifdef NEED_PROTOTYPES

#ifndef __THING_PROPERTIES_H_PROTO__
#define __THING_PROPERTIES_H_PROTO__

// prototypes

// direct property access
public mixed Set(string name, mixed Value,
                 int Type = F_VALUE, int drop_priv = extern_call());
public mixed Query(string name, int Type = F_VALUE);

// filtered property access
public mixed SetProp(string name, mixed Value, int drop_priv = extern_call());
public mixed QueryProp(string name);
public mixed AddToProp(string pname,
                       <int|float|string|mixed*|mapping|bytes> add_value);
public mixed SubFromProp(string pname,
                       <int|float|string|mixed*|mapping|bytes> sub_value);

// global property handling
public void SetProperties(mapping props);
public mapping QueryProperties();

// misc/interna
public mixed *__query_properties();
public void _set_save_data(mixed data);
public mixed _get_save_data();

#endif // __THING_PROPERTIES_H_PROTO__

#endif // NEED_PROTOTYPES
