#pragma strict_types, rtt_checks, lightweight

#define NEED_PROTOTYPES
#include <player/comm.h>

inherit "/std/player/comm_structs";

private nosave string uuid;
// nosave ist wichtig - niemand soll den buffer mit save_value() auslesen
// koennen!
private nosave struct kobold_msg_s *buffer = ({});

protected void create_lw()
{
    uuid = getuuid(previous_object());
}

public string uuid()
{
    return uuid;
}

public struct kobold_msg_s *Retrieve()
{
    if (uuid == getuuid(previous_object()))
    {
        return buffer;
    }
    return 0;
}

public void Empty()
{
    if (uuid == getuuid(previous_object()))
    {
        buffer = ({});
    }
}

public int store_msg(string msg, int msg_type, string msg_action,
                     string msg_prefix, object origin)
{
    // Nur KOBOLD in /secure darf Nachrichten speichern und es werden nur
    // Nachrichten von Spielern/Magiern gespeichert.
    if (object_name(previous_object()) != KOBOLD
        || !query_once_interactive(origin))
        return MSG_FAILED;
    if (sizeof(buffer) >= MAX_KOBOLD_LIMIT)
        return MSG_BUFFER_FULL;

    buffer += ({ (<kobold_msg_s> msg:msg, type:msg_type,
                  prefix: msg_prefix, action: msg_action,
                  sendername: ({string})origin.query_real_name(),
                  timestamp: time())
               });
    return MSG_BUFFERED;
}

