// MorgenGrauen MUDlib
//
// player/comm.c-- basic player communiction commands
//
// $Id: comm.c 6918 2008-08-07 21:13:16Z Zesstra $

#pragma strong_types
#pragma save_types
#pragma no_clone
#pragma range_check

// Struct fuer im Kobold, im Comm-Vault und in der TM-History gespeicherte
// Nachrichten.
// Basiert auf allgemeiner wave_s Struktur aus /secure/simul_efun/comm.c
struct kobold_msg_s (wave_s) {
  string action;    // Messageaction fuer ReceiveMsg
  string sendername;// Ursprung der Nachricht
  int timestamp;    // Zeitstempel der Nachricht
};

// Buffer fuer den Kobold im Spielerobjekt
struct kobold_buffer_s {
  struct kobold_msg_s *buf;
  int index;
};

// Struktur fuer Gespraeche in der TM-History
struct chat_s {
  string uid;           // UID des Gespraechspartners
  int time_first_msg;   // Zeit der ersten Nachricht
  int time_last_msg;    // Zeit der letzen Nachricht
  int sentcount;        // Anzahl gesendeter Nachrichten
  int recvcount;        // Anzahl empfangener Nachrichten
  struct kobold_msg_s *msgbuf;  // Array von kobold_msg_s (Art Ringpuffer)
  int ptr;              // Pointer auf die naechste zu ueberschreibende msg_s
                        // in msgbuf
};

